from . import db, bcrypt
from flask import Blueprint, request, jsonify, make_response
from  werkzeug.security import generate_password_hash, check_password_hash
from flask_jwt_extended import create_access_token, jwt_required, get_jwt_identity
from .AuthContext import token_required
import jwt
from datetime import datetime, timedelta
from app.config import Config


from .models import User
from .utils import allowed_file, save_image

auth = Blueprint('auth', __name__)

@auth.route('/register', methods=['POST'])
def register():
    try:
        data = request.get_json()
        
        if not data or not data.get('email') or not data.get('password') or not data.get('username'):
            return jsonify({'error': 'Missing required fields'}), 400
        
        if User.query.filter_by(email=data['email']).first():
            return jsonify({'error': 'Email already registered'}), 409
        
        if User.query.filter_by(username=data['username']).first():
            return jsonify({'error': 'Username already taken'}), 409
        
        user = User(
            username=data['username'],
            email=data['email'],
            is_admin=data.get('is_admin', False)
        )
        user.set_password(data['password'])
        
        db.session.add(user)
        db.session.commit()
        
        access_token = create_access_token(identity=user.id)
        
        return jsonify({
            'message': 'User created successfully',
            'access_token': access_token,
            'user': user.to_dict()
        }), 201   
    except Exception as e:
        db.session.rollback()
        return jsonify({'error': str(e)}), 500

@auth.route('/logings', methods =['POST'])
def logings():
    auth = request.get_json()
    if not auth or not auth.get('email') or not auth.get('password'):
       
        return make_response(
            'Could not verify',
            401,
            {'WWW-Authenticate' : 'Basic realm ="Login required !!"'}
        )
    user = User.query\
        .filter_by(email = auth.get('email'))\
        .first()
  
    if not user:
        print('auth', user)
        return make_response(
            'Could not verify',
            401,
            {'WWW-Authenticate' : 'Basic realm ="User does not exist !!"'}
        )
    if not user.is_active:
        print(user.is_active)
        return jsonify({'error': 'Account deactivated'}), 403
        
  
    if user.check_password(auth.get('password')):
        token = jwt.encode({
            'public_id': user.id,
            'exp' : datetime.utcnow() + timedelta(days = 30)
        }, Config.SECRET_KEY)
  
        return make_response(jsonify({'message': 'Login successful', 'token' : token,  'user': user.to_dict()}), 201)

    return make_response(
        'Could not verify',
        403,
        {'WWW-Authenticate' : 'Basic realm ="Wrong Password !!"'}
        )
    
@auth.route("/protected", methods=["POST"])
@token_required
def protected(current_user):
    current_user = get_jwt_identity()
    return jsonify(logged_in_as=current_user), 200


@auth.route('/profile', methods=['GET', 'POST'])
@token_required
def get_profile(current_user):
    try:
        user_id = current_user.id
        print(f"Profile request for user ID: {user_id}") 
        
        user = User.query.get(user_id)
        if not user:
            return jsonify({'error': 'User not found'}), 404
        
        return jsonify({'user': user.to_dict()}), 200
        
    except Exception as e:
        print(f"Error in profile endpoint: {str(e)}")  
        return jsonify({'error': str(e)}), 500

@auth.route('/profile', methods=['PUT'])
@jwt_required()
def update_profile():
    try:
        user_id = get_jwt_identity()
        user = User.query.get_or_404(user_id)
        data = request.get_json()
        
        if 'username' in data:
            if User.query.filter(User.id != user_id, User.username == data['username']).first():
                return jsonify({'error': 'Username already taken'}), 409
            user.username = data['username']
        
        if 'email' in data:
            if User.query.filter(User.id != user_id, User.email == data['email']).first():
                return jsonify({'error': 'Email already registered'}), 409
            user.email = data['email']
        
        if 'password' in data and data['password']:
            user.set_password(data['password'])
        
        db.session.commit()
        
        return jsonify({
            'message': 'Profile updated successfully',
            'user': user.to_dict()
        }), 200
        
    except Exception as e:
        db.session.rollback()
        return jsonify({'error': str(e)}), 500